/*
 * Copyright 2015-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.style.outline.border;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Painter;

/**
 * Provides utility methods to draw borders.
 */
public class BorderHelper {

	private BorderHelper() {
		// private constructor
	}

	/**
	 * Draw a rectangular border with the given dimensions and given thickness for each side, using the given graphics
	 * context.
	 *
	 * @param g
	 *            the graphics context to use.
	 * @param width
	 *            the width of the border.
	 * @param height
	 *            the height of the border.
	 * @param left
	 *            the left thickness of the border.
	 * @param top
	 *            the top thickness of the border.
	 * @param right
	 *            the right thickness of the border.
	 * @param bottom
	 *            the bottom thickness of the border.
	 */
	public static void drawRectangularBorder(GraphicsContext g, int width, int height, int left, int top, int right,
			int bottom) {
		// draw left border
		Painter.fillRectangle(g, 0, 0, left, height);

		// draw top border
		Painter.fillRectangle(g, 0, 0, width, top);

		// draw right border
		Painter.fillRectangle(g, width - right, 0, right, height);

		// draw bottom border
		Painter.fillRectangle(g, 0, height - bottom, width, bottom);
	}
}
