/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion.bounce;

import ej.bon.XMath;
import ej.motion.Motion;
import ej.motion.MotionManager;
import ej.motion.quad.QuadEaseOutMotion;
import ej.motion.util.TossHelper;

/**
 * Motion manager creating bounce motions.
 */
public class BounceMotionManager implements MotionManager {

	@Override
	public Motion easeIn(int start, int stop, long duration) {
		return new BounceEaseInMotion(start, stop, duration);
	}

	@Override
	public Motion easeOut(int start, int stop, long duration) {
		return new BounceEaseOutMotion(start, stop, duration);
	}

	@Override
	public Motion easeInOut(int start, int stop, long duration) {
		return new BounceEaseInOutMotion(start, stop, duration);
	}

	@Override
	public Motion toss(int start, int min, int max, float initialSpeed, long duration) {
		int stop = TossHelper.computeExpectedStop(start, initialSpeed, duration);
		stop = XMath.limit(stop, min, max);
		if (stop == min || stop == max) {
			return new BounceEaseOutMotion(start, stop, duration);
		} else {
			return new QuadEaseOutMotion(start, stop, duration);
		}
	}
}
