/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion;

/**
 * A motion factory creates a standard motion.
 */
public interface MotionFactory {

	/**
	 * Instantiates a standard new motion.
	 *
	 * @param start
	 *            the start value.
	 * @param stop
	 *            the stop value.
	 * @param duration
	 *            the duration of the motion.
	 * @return the motion for the move.
	 */
	Motion createMotion(int start, int stop, long duration);
}
