/*
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.motion;

/**
 * Represents a running motion.
 */
public interface Motion {

	/**
	 * Gets the motion duration.
	 *
	 * @return the motion duration.
	 */
	long getDuration();

	/**
	 * Gets whether the motion is finished or not.
	 * <p>
	 * A motion is finished when the current value is the stop one.
	 *
	 * @return {@code true} if the motion is finished, {@code false} otherwise.
	 */
	boolean isFinished();

	/**
	 * Starts (or starts again) the motion.
	 */
	void start();

	/**
	 * Computes the current value of the motion.
	 * <p>
	 * If the motion is finished, returns the stop value.
	 *
	 * @return the current value.
	 * @see #isFinished()
	 */
	int getCurrentValue();

	/**
	 * Gets the start value of the motion.
	 *
	 * @return the start value.
	 */
	int getStartValue();

	/**
	 * Gets the stop value of the motion.
	 *
	 * @return the stop value.
	 */
	int getStopValue();

	/**
	 * Gets the value of the motion for a specific elapsed time.
	 *
	 * @param elapsed
	 *            the absolute elapsed time.
	 * @return the value for the given time.
	 */
	int getValue(long elapsed);

}
