/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util.server;

import ej.basictool.map.PackedMap;
import ej.bluetooth.BluetoothDevice;

/*package*/ class ServerStorage {

	private static final PackedMap<BluetoothDevice, PackedMap<Object, byte[]>> Devices = new PackedMap<>();

	public static byte[] get(BluetoothDevice device, Object attribute) {
		PackedMap<Object, byte[]> deviceStorage = Devices.get(device);
		if (deviceStorage == null) {
			return null;
		}

		return deviceStorage.get(attribute);
	}

	public static void set(BluetoothDevice device, Object attribute, byte[] value) {
		PackedMap<Object, byte[]> deviceStorage = Devices.get(device);
		if (deviceStorage == null) {
			deviceStorage = new PackedMap<>();
			Devices.put(device, deviceStorage);
		}

		deviceStorage.put(attribute, value);
	}

	/**
	 * Remove a device.
	 *
	 * @param device
	 *            the device to remove.
	 */
	public static void remove(BluetoothDevice device) {
		Devices.remove(device);
	}
}
