/*
 * Copyright (c) 1999, 2012, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2017-2020 MicroEJ Corp. - EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package javax.net.ssl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;

import ej.annotation.Nullable;

/**
 * This class acts as a factory for key managers based on a source of key material. Each key manager manages a specific
 * type of key material for use by secure sockets. The key material is based on a KeyStore and/or provider specific
 * sources.
 *
 * @since 1.4
 * @see KeyManager
 */
public class KeyManagerFactory {

	/**
	 * Obtains the default KeyManagerFactory algorithm name.
	 *
	 * <p>
	 * The default algorithm can be changed at runtime by setting the value of the
	 * {@code ssl.KeyManagerFactory.algorithm} security property to the desired algorithm name.
	 *
	 * @return the default algorithm name as specified by the {@code ssl.KeyManagerFactory.algorithm} security property,
	 *         or an implementation-specific default if no such property exists.
	 */
	public final static String getDefaultAlgorithm() {
		throw new RuntimeException();
	}

	/**
	 * Returns the algorithm name of this <code>KeyManagerFactory</code> object.
	 *
	 * <p>
	 * This is the same name that was specified in one of the <code>getInstance</code> calls that created this
	 * <code>KeyManagerFactory</code> object.
	 *
	 * @return the algorithm name of this <code>KeyManagerFactory</code> object.
	 */
	public final String getAlgorithm() {
		throw new RuntimeException();
	}

	/**
	 * Returns a <code>KeyManagerFactory</code> object that acts as a factory for key managers.
	 *
	 * <p>
	 * This method traverses the list of registered security Providers, starting with the most preferred Provider. A new
	 * KeyManagerFactory object encapsulating the KeyManagerFactorySpi implementation from the first Provider that
	 * supports the specified algorithm is returned.
	 *
	 *
	 * @param algorithm
	 *            the standard name of the requested algorithm. See the
	 *            <a href= "{@docRoot}/../technotes/guides/security/jsse/JSSERefGuide.html"> Java Secure Socket
	 *            Extension Reference Guide </a> for information about standard algorithm names.
	 *
	 * @return the new <code>KeyManagerFactory</code> object.
	 *
	 * @exception NoSuchAlgorithmException
	 *                if no Provider supports a KeyManagerFactorySpi implementation for the specified algorithm.
	 * @exception NullPointerException
	 *                if <code>algorithm</code> is null.
	 *
	 */
	public static final KeyManagerFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
		throw new RuntimeException();
	}

	/**
	 * Initializes this factory with a source of key material.
	 * <P>
	 * The provider typically uses a KeyStore for obtaining key material for use during secure socket negotiations. The
	 * KeyStore is generally password-protected.
	 * <P>
	 *
	 * @param ks
	 *            the key store or null
	 * @param password
	 *            the password for recovering keys in the KeyStore
	 * @throws KeyStoreException
	 *             if this operation fails
	 * @throws NoSuchAlgorithmException
	 *             if the specified algorithm is not available from the specified provider.
	 * @throws UnrecoverableKeyException
	 *             if the key cannot be recovered (e.g. the given password is wrong).
	 */
	public final void init(@Nullable KeyStore ks, char[] password)
			throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
		throw new RuntimeException();
	}

	/**
	 * Returns one key manager for each type of key material.
	 *
	 * @return the key managers
	 * @throws IllegalStateException
	 *             if the KeyManagerFactory is not initialized
	 */
	public final KeyManager[] getKeyManagers() {
		throw new RuntimeException();
	}
}
