/*
 * Copyright 2017-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.widget.swipe;

/**
 * A swipeable element receives notifications from a {@link SwipeEventHandler}.
 */
public interface Swipeable {

	/**
	 * The content is moved to the given position.
	 *
	 * @param position
	 *            the new position
	 */
	void onMove(int position);

}
