/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

/**
 * This class associates a string with a font. The string rendering is accelerated because the couple string/font is
 * fixed.
 */
public class RenderableString {

	/**
	 * Creates a renderable string for given string and font.
	 *
	 * @param string
	 *            the string to render
	 * @param font
	 *            the font used to render the string
	 *
	 * @throws NullPointerException
	 *             when font or string is null
	 * @throws IllegalArgumentException
	 *             when string is empty
	 */
	public RenderableString(String string, Font font) {
		throw new RuntimeException();
	}

	/**
	 * Gets the string to draw.
	 *
	 * @return the string.
	 */
	public String getString() {
		throw new RuntimeException();
	}

	/**
	 * Gets the font used to draw the string.
	 *
	 * @return the font.
	 */
	public Font getFont() {
		throw new RuntimeException();
	}

	/**
	 * Gets the width of the string with the font. Same specification than {@link Font#stringWidth(String)}.
	 *
	 * @return the width taken by the string.
	 * @see Font#stringWidth(String)
	 */
	public int getWidth() {
		throw new RuntimeException();
	}

	/**
	 * Gets the height of a line of text with this font and its y ratio. Same specification than
	 * {@link Font#getHeight()}.
	 *
	 * @return height of a line of text with this font.
	 */
	public int getHeight() {
		throw new RuntimeException();
	}

	/**
	 * Draws the string using the font and given graphics context color. Same specification than
	 * {@link GraphicsContext#drawString(String, int, int, int)}
	 *
	 * @param gc
	 *            the graphics context where draw the string
	 * @param x
	 *            the x coordinate of the anchor point.
	 * @param y
	 *            the y coordinate of the anchor point.
	 * @param anchor
	 *            position of the string around the anchor point.
	 * @see GraphicsContext#drawString(String, int, int, int)
	 */
	public void draw(GraphicsContext gc, int x, int y, int anchor) {
		throw new RuntimeException();
	}
}
