/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothProperties</code> class enumerates the values for characteristic properties.
 * <p>
 * Multiple flags may be combined to create a set of properties.
 * <p>
 * Characteristic properties are not used to control access to the characteristic. The properties are only used as an
 * indication to the client on how this characteristic may be used.
 * <p>
 * Refer to «Core Specification Vol 3, Part G, 3.3.1.1 Characteristic Properties».
 */
public class BluetoothProperties {

	/** No property. */
	public static final byte NONE = 0x00;

	/** Indicates that the characteristic value may be broadcasted in advertisement data. */
	public static final byte BROADCAST = 0x01;

	/** Indicates that the characteristic value may be read. */
	public static final byte READ = 0x02;

	/** Indicates that the characteristic value may be written (using write without response procedure). */
	public static final byte WRITE_NO_RESPONSE = 0x04;

	/** Indicates that the characteristic value may be written. */
	public static final byte WRITE = 0x08;

	/** Indicates that the characteristic supports notifications. */
	public static final byte NOTIFY = 0x10;

	/** Indicates that the characteristic supports indications. */
	public static final byte INDICATE = 0x20;

	/** Indicates that the characteristic value may be written (using signed write procedure). */
	public static final byte WRITE_SIGNED = 0x40;

	/** Indicates that additional properties are defined in the Characteristic Extended Properties descriptor. */
	public static final byte EXTENDED = (byte) 0x80;

	/**
	 * Private constructor.
	 */
	private BluetoothProperties() {
		throw new RuntimeException();
	}
}
