/*
 * Copyright (c) 2022, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2022 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

package com.microej.stringformat;

import java.util.Formatter;
import java.util.IllegalFormatException;

import ej.annotation.Nullable;
import ej.basictool.annotation.Extend;

/**
 * Extension format method for the {@link String} class.
 */
public class StringFormatExtension {

	/**
	 * Returns a formatted string using the specified format string and arguments.
	 *
	 * @param format
	 *            A format string
	 *
	 * @param args
	 *            Arguments referenced by the format specifiers in the format string. If there are more arguments than
	 *            format specifiers, the extra arguments are ignored. The number of arguments is variable and may be
	 *            zero. The maximum number of arguments is limited by the maximum dimension of a Java array as defined
	 *            by <cite>The Java&trade; Virtual Machine Specification</cite>. The behaviour on a <tt>null</tt>
	 *            argument depends on the Formatter conversion.
	 *
	 * @throws IllegalFormatException
	 *             If a format string contains an illegal syntax, a format specifier that is incompatible with the given
	 *             arguments, insufficient arguments given the format string, or other illegal conditions. For
	 *             specification of all possible formatting errors, see the Details section of the formatter class
	 *             specification.
	 *
	 * @throws NullPointerException
	 *             If the <tt>format</tt> is <tt>null</tt>
	 *
	 * @return A formatted string
	 *
	 * @see java.util.Formatter
	 */
	@Extend(className = "java.lang.String", isStatic = true)
	public static String format(String format, @Nullable Object... args) {
		return new Formatter().format(format, args).toString();
	}

}
