/*
 * Java
 *
 * Copyright 2020-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui.display;

import ej.microui.MicroUIException;

/**
 * A <code>BufferedImage</code> represents a mutable image backed by a pixel buffer.
 * <p>
 * The constructor of this class allows to create an image with given dimensions and format.
 */
public class BufferedImage extends ResourceImage {

	/**
	 * Creates a buffered image with the same format as the display.
	 * <p>
	 * Equivalent to calling {@link #BufferedImage(int, int, Format)} with {@link Format#DISPLAY} as parameter.
	 * <p>
	 * The output format of the new image matches the pixel organization (layout, depth, etc.) of the default display.
	 *
	 * @param width
	 *            the width of the new image, in pixels.
	 * @param height
	 *            the height of the new image, in pixels.
	 * @throws IllegalArgumentException
	 *             if either <code>width</code> or <code>height</code> is negative or zero.
	 * @throws MicroUIException
	 *             if the image could not be created.
	 * @throws MicroUIException
	 *             if MicroUI is not started.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to create an image.
	 */
	public BufferedImage(int width, int height) {
		throw new RuntimeException();
	}

	/**
	 * Creates a buffered image specifying its format.
	 * <p>
	 * The new image is initialized with unspecified data.
	 * <p>
	 * Creating images is not supported by every MicroUI implementation. If the MicroUI implementation does not support
	 * the allocation of memory in order to store the image buffer or if the format is not supported, a
	 * {@link MicroUIException} is thrown.
	 * <p>
	 * An image with a custom format can be based on pixels (as the standard formats) but can also be based on anything
	 * else. For instance, it can save the list of drawings and replay them when the image is drawn.
	 *
	 * @param width
	 *            the width of the new image, in pixels.
	 * @param height
	 *            the height of the new image, in pixels.
	 * @param format
	 *            the format of the new image.
	 * @throws IllegalArgumentException
	 *             if either <code>width</code> or <code>height</code> is negative or zero or is greater than
	 *             implementation limit.
	 * @throws MicroUIException
	 *             if there is not enough room to allocate the buffer.
	 * @throws MicroUIException
	 *             if the format is not supported.
	 * @throws MicroUIException
	 *             if MicroUI is not started.
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to create an image.
	 */
	public BufferedImage(int width, int height, Format format) {
		throw new RuntimeException();
	}

	/**
	 * Gets the {@link GraphicsContext} associated with this image, which may be used in order to draw on the image.
	 * <p>
	 * This method always returns the same {@link GraphicsContext} instance for a specific image. The graphics context
	 * has the same dimensions as the image, which allows to modify every pixel of the image.
	 *
	 * @throws MicroUIException
	 *             if this image has been closed (see {@link ResourceImage#close()}).
	 * @return the image's graphics context.
	 */
	public GraphicsContext getGraphicsContext() {
		throw new RuntimeException();
	}

	/**
	 * Gets the format of this image.
	 *
	 * @return the format of this image.
	 */
	public Format getFormat() {
		throw new RuntimeException();
	}

}
