/*
 * Java
 *
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * Permission to start or stop MicroUI. Permissions are checked when calling {@link MicroUI#start()} and
 * {@link MicroUI#stop()}
 *
 * @see MicroUI#start()
 * @see MicroUI#stop()
 */
public class MicroUIPermission extends Permission {

	/**
	 * Action to start MicroUI.
	 */
	public static final String ACTION_START = "start"; //$NON-NLS-1$

	/**
	 * Action to stop MicroUI.
	 */
	public static final String ACTION_STOP = "stop"; //$NON-NLS-1$

	/**
	 * Creates a permission for events generated by the given event generator with <code>null</code> as name.
	 *
	 * @param action
	 *            the action to check.
	 */
	public MicroUIPermission(String action) {
		super(null);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
