/*
 * Java
 *
 * Copyright 2014-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.event;

/**
 * An event handler is intended to receive and handle events.
 * <p>
 * In the MVC pattern it is the controller.
 *
 * @since 2.0
 */
public interface EventHandler {

	/**
	 * Handles an event.
	 *
	 * @param event
	 *            the event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 *
	 * @see Event
	 */
	boolean handleEvent(int event);

}
