/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for display permissions.
 * <p>
 * The name is related to the display APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>access
 * <dd>access permission. Permission is checked when calling <code>Display#requestShow(Displayable)</code>.
 * </dl>
 *
 * @see java.security.Permission
 *
 * @since 2.0
 */
public class DisplayPermission extends Permission {

	/**
	 * Creates the display permission for the display with <code>null</code> as name.
	 */
	public DisplayPermission() {
		super(null);
		throw new RuntimeException();
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}
}
