/*
 * Java
 *
 * Copyright 2022-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.microui.display;

import ej.bon.Constants;

/**
 * Since UI pack 13.2.0, the MicroUI Graphics Engine integrates a set of methods to obtain certain characteristics of
 * the engine.
 */
@SuppressWarnings("nls")
public class DisplayUtilities {

	/**
	 * {@link Constants} value that indicates if the MicroUI Graphics Engine testsuite support is enabled. If enabled,
	 * the {@link DisplayUtilities} native methods can be called. Otherwise the c
	 */
	public static final String MICROUI_TESTSUITE_SUPPORT = "com.microej.microui.testsuite.support";

	private static final int FUNCTION_ID_GETNEXTFLUSHBOUNDS = 1;

	/**
	 * @param flushBounds
	 *            deprecated
	 * @return false
	 */
	@Deprecated
	public static boolean getNextFlushBounds(int[] flushBounds) {
		if (Constants.getBoolean(MICROUI_TESTSUITE_SUPPORT)
				&& !DisplayUtilitiesNatives.isDeprecated(FUNCTION_ID_GETNEXTFLUSHBOUNDS)) {
			return DisplayUtilitiesNatives.getNextFlushBounds(Display.getDisplay().getGraphicsContext().getSNIContext(),
					flushBounds);
		}
		throw new RuntimeException();
	}
}
