/*
 * Copyright 2015-2018 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.service.loader;

import ej.annotation.Nullable;
import ej.basictool.ArrayTools;
import ej.service.ServiceLoader;

/**
 * A composite service loader contains a list a service loaders. It searches the requested services in its children
 * sequentially respecting the order they are added.
 */
public class CompositeServiceLoader extends SimpleServiceLoader {

	private ServiceLoader[] serviceLoaders;

	/**
	 * Creates a new empty composite service loader.
	 */
	public CompositeServiceLoader() {
		this.serviceLoaders = new ServiceLoader[0];
	}

	/**
	 * Adds a service loader at the end of the list a service loaders used by this composite service loader.
	 *
	 * @param serviceLoader
	 *            the service loader to add.
	 * @throws NullPointerException
	 *             if the given service loader is <code>null</code>.
	 */
	public void addServiceLoader(ServiceLoader serviceLoader) {
		this.serviceLoaders = ArrayTools.add(this.serviceLoaders, serviceLoader);
	}

	@Override
	@Nullable
	public <T> T getService(Class<T> service) {
		for (ServiceLoader serviceLoader : this.serviceLoaders) {
			T serviceInstance = serviceLoader.getService(service);
			if (serviceInstance != null) {
				return serviceInstance;
			}
		}
		return super.getService(service);
	}

}
