/*
 * Java
 *
 * Copyright 2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bon;

import java.io.EOFException;
import java.io.IOException;

/**
 * A resource array is an element of {@link ResourceBuffer}. It holds a set of
 * data. The data size in bytes is the same for all elements (aligned on bigger
 * encoded element). Each element data is aligned in memory on element size: 4
 * bytes for 32-bits values and 2 bytes for 16-bits values. The
 * {@link ResourceBuffer} encoder ensures the array is aligned too (using the
 * same rule).
 */
public class ResourceArray {

	/**
	 * Creates a resource array. Only an instance of {@link ResourceBuffer} can
	 * to create an array on its data.
	 *
	 * @param buf
	 *            the {@link ResourceBuffer} buffer
	 * @throws EOFException
	 *             when end of file of {@link ResourceBuffer} is reached.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	/* package visibililty */
	ResourceArray(ResourceBuffer buf) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Returns the {@link ResourceBuffer} used to create the
	 * {@link ResourceArray}.
	 *
	 * @return the {@link ResourceBuffer}
	 */
	public ResourceBuffer getBuffer() {
		throw new RuntimeException();
	}

	/**
	 * Gets the number of elements contained in the array (not the size in
	 * bytes).
	 *
	 * @return the available number of elements
	 */
	public int length() {
		throw new RuntimeException();
	}

	/**
	 * Reads the element at given index.
	 *
	 * @param index
	 *            the element index
	 * @return the element read
	 * @throws IOException
	 *             if an I/O error occurs.
	 * @throws IndexOutOfBoundsException
	 *             when the index is negative or higher or equal than
	 *             {@link #length()}.
	 */
	public int elementAt(int index) throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Reads all array elements.
	 *
	 * @return the elements read.
	 * @throws IOException
	 *             if an I/O error occurs.
	 */
	public int[] elements() throws IOException {
		throw new RuntimeException();
	}

	/**
	 * Modify the position of the {@link ResourceBuffer} used to create this
	 * {@link ResourceArray}. Updates its position to point on the element
	 * defined at the given index.
	 *
	 * @param index
	 *            the {@link ResourceBuffer} offset pointer
	 * @return the {@link ResourceBuffer} used to create the
	 *         {@link ResourceArray}.
	 * @throws IOException
	 *             if an I/O error occurs.
	 * @throws IndexOutOfBoundsException
	 *             when the index is negative or higher or equal than
	 *             {@link #length()}.
	 */
	public ResourceBuffer seekToElementPointer(int index) throws IOException {
		throw new RuntimeException();
	}

}
