/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg;

/**
 * Provides the MicroVG library constants: commands, blend modes, fill rules, etc.
 */
public interface LLVGConstants {

	/**
	 * MicroVG "CLOSE" command.
	 */
	int COMMAND_CLOSE = 0;

	/**
	 * MicroVG "MOVE ABS" command.
	 */
	int COMMAND_MOVE = 1;

	/**
	 * MicroVG "MOVE REL" command.
	 */
	int COMMAND_MOVE_REL = 2;

	/**
	 * MicroVG "LINE ABS" command.
	 */
	int COMMAND_LINE = 3;

	/**
	 * MicroVG "LINE REL" command.
	 */
	int COMMAND_LINE_REL = 4;

	/**
	 * MicroVG "QUAD EBS" command.
	 */
	int COMMAND_QUAD = 5;

	/**
	 * MicroVG "QUAD REL" command.
	 */
	int COMMAND_QUAD_REL = 6;

	/**
	 * MicroVG "CUBIC ABS" command.
	 */
	int COMMAND_CUBIC = 7;

	/**
	 * MicroVG "CUBIC REL" command.
	 */
	int COMMAND_CUBIC_REL = 8;

	/**
	 * MicroVG library "WINDING" fill rule.
	 */
	int FILLTYPE_WINDING = 0;

	/**
	 * MicroVG library "EVEN_ODD" fill rule.
	 */
	int FILLTYPE_EVEN_ODD = 1;

	/**
	 * MicroVG library "SRC" blending mode.
	 */
	int BLEND_SRC = 0;

	/**
	 * MicroVG library "SRC_OVER" blending mode.
	 */
	int BLEND_SRC_OVER = 1;

	/**
	 * MicroVG library "DST_OVER" blending mode.
	 */
	int BLEND_DST_OVER = 2;

	/**
	 * MicroVG library "SRC_IN" blending mode.
	 */
	int BLEND_SRC_IN = 3;

	/**
	 * MicroVG library "DST_IN" blending mode.
	 */
	int BLEND_DST_IN = 4;

	/**
	 * MicroVG library "DST_OUT" blending mode.
	 */
	int BLEND_DST_OUT = 5;

	/**
	 * MicroVG library "PLUS" blending mode.
	 */
	int BLEND_PLUS = 6;

	/**
	 * MicroVG library "SCREEN" blending mode.
	 */
	int BLEND_SCREEN = 7;

	/**
	 * MicroVG library "MULTIPLY" blending mode.
	 */
	int BLEND_MULTIPLY = 8;
}
