/*
 * Copyright 2022-2023 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.android.application;

import com.microej.android.MicroEJSupport;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;

/* package */ class MicroEJView extends View implements ApplicationDisplay {

	private Bitmap flushBitmap;

	public MicroEJView(Context context) {
		super(context);
	}

	@Override
	protected void onAttachedToWindow() {
		MicroEJSupport.getApplicationSupport().setDisplay(this);
		super.onAttachedToWindow();
	}

	@Override
	protected void onDetachedFromWindow() {
		MicroEJSupport.getApplicationSupport().unsetDisplay(this);
		super.onDetachedFromWindow();
	}

	@Override
	public void flush(Bitmap bitmap, Rect bounds) {
		this.flushBitmap = bitmap;
		postInvalidate();
	}

	@Override
	protected void onDraw(Canvas canvas) {
		Bitmap flushBitmap = this.flushBitmap;
		if (flushBitmap != null) {
			canvas.drawBitmap(flushBitmap, 0.0f, 0.0f, null);
			MicroEJSupport.getApplicationSupport().onDisplayTearing(this);
		}
	}
}
