/*
 * Copyright 2016-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.animation;

/**
 * An animation is responsible for animating a element (usually a visual one).
 */
public interface Animation {

	/**
	 * Called regularly by an animator.
	 * <p>
	 * The given time is based on {@link ej.bon.Util#platformTimeMillis()} which is monotonic.
	 * <p>
	 * This method is executed in the MicroUI thread.
	 *
	 * @param currentTimeMillis
	 *            the current time in milliseconds.
	 * @return <code>true</code> if the animation continue, <code>false</code> if the animation must stop.
	 */
	boolean tick(long currentTimeMillis);

}
