/*
 * Java
 *
 * Copyright 2016-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.ecom.wifi;

/**
 * List of Wi-Fi Protected Setup (WPS) modes.
 */
public enum WPSMode {
	/**
	 * Near Field Communication (NFC) method.
	 */
	NFC,
	/**
	 * No method.
	 */
	NONE,
	/**
	 * Personal Identification Number (PIN) method.
	 */
	PIN,
	/**
	 * Push button method.
	 */
	PushButton,
	/**
	 * USB method.
	 */
	USB

}
