/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.services;

/**
 * This service allows Features to get device information.
 */
public interface DeviceService {

	/**
	 * Returns the current battery level.
	 *
	 * @return the battery level (in %).
	 */
	int getBatteryLevel();

	/**
	 * Returns whether the battery is currently charging.
	 *
	 * @return <code>true</code> if the battery is charging, <code>false</code> if it is not charging.
	 */
	boolean isBatteryCharging();
}
