/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.websocket;

/**
 * This is a more specific {@link WebSocketException} type. It is thrown during when the error is caused by the server (such as an invalid HTTP status
 * code during the opening handshake).
 *
 *
 *
 */
public class ServerException extends WebSocketException {

	private int httpStatusCode = 0;

	/**
	 * Serial Version UID.
	 */
	private static final long serialVersionUID = 6104834258602150240L;

	/**
	 * Create a new server exception.
	 *
	 * @param string
	 *            message to describe the error case
	 */
	public ServerException(String string) {
		super(string);
	}

	/**
	 *
	 */
	public ServerException() {
		super();
	}

	/**
	 * Get the the HTTP status code returned by the server.
	 *
	 * @return the status code ; 0 if the code could not be determined
	 */
	public int getHttpStatusCode() {
		return httpStatusCode;
	}

	/**
	 * Set the the HTTP status code returned by the server.
	 *
	 * @param httpStatusCode
	 *            the status code
	 */
	public void setHttpStatusCode(int httpStatusCode) {
		this.httpStatusCode = httpStatusCode;
	}

}
