/*
 * Java
 *
 * Copyright 2017-2022 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.hoka.http.body;

import java.io.IOException;
import java.io.InputStream;

import ej.annotation.Nullable;
import ej.hoka.http.HttpRequest;

/**
 * A parser called to read the body of an {@link HttpRequest}.
 *
 * @param <T>
 *            the body type.
 */
public interface BodyParser<T> {

	/**
	 * Parse the body.
	 *
	 * @param inputStream
	 *            the body {@link InputStream}.
	 * @param contentType
	 *            the <code>"content-type"</code> header of the request.
	 * @return the body.
	 * @throws IOException
	 *             when an {@link IOException} occurs during the parsing.
	 */
	T parseBody(InputStream inputStream, @Nullable String contentType) throws IOException;

}
