/*
 * Copyright 2010-2015 http://beders.github.com/Resty
 * Copyright 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ej.rest.web;

import java.io.IOException;
import java.io.InputStream;

/**
 * This is a text/* representation of a resource.
 * 
 * @author beders
 * 
 */
public class TextResource extends AbstractResource {
	/*
	static final Pattern charsetPattern = Pattern.compile("charset=([^ ;]+);?");
	 */
	protected String text;

	public TextResource(Option... options) {
		super(options);
	}

	/**
	 * Kinda obvious, but, yes, it parses the inputStream with the proper charset
	 * and returns the content as String
	 * 
	 */
	@Override
	public String toString() {
		if (text == null && inputStream != null) {
			text = readTextFromStream(inputStream);
			try {
				inputStream.close();
			} catch (IOException e) {/* Intentionally left empty */}
		}
		return text;
	}

	protected String readTextFromStream(InputStream aTextStream) {
		/*Charset charset = getCharSet();*/
		StringBuffer sb = new StringBuffer();
		//		int size = urlConnection.getContentLength();
		//		ByteArrayOutputStream bos = new ByteArrayOutputStream(size != -1 ? size : 1024);
		byte[] buffer = new byte[1024];
		int len;
		try {
			while ((len = aTextStream.read(buffer)) != -1) {
				//				bos.write(buffer, 0, len);
				//assuming ASCII
				sb.append(new String(buffer, 0, len));
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
		//		String streamedText = ""; // be robust
		//		streamedText = bos.toString(/*charset.name()*/);
		//		byte[] bytes = sb.toString().getBytes();
		//
		//		System.out.print("new byte[]{");
		//		for(int i = 0; i < bytes.length; i++){
		//			System.out.print(bytes[i]);
		//			System.out.print(", ");
		//		}
		//		System.out.println("}");
		//		System.out.println(bytes.length);

		/*
		try {
		} catch (UnsupportedEncodingException e) {
		} // we already checked for that above
		// check Content-Type text/plain; charset=iso-8859-1
		 * 
		 */
		//		return streamedText;
		return sb.toString();

	}

	/**
	 * Get charset for this content type. Parses charset= attribute of content
	 * type or falls back to a default
	 * 
	 * @return the charset to use when parsing this content
	 */
	/*
	protected Charset getCharSet() {
		String contentType = urlConnection.getContentType();
		Charset charset = Charset.forName("iso-8859-1"); // default charset
		if (contentType != null) {
			// find out about the charset from the URLConnection
			Matcher m = charsetPattern.matcher(contentType);
			if (m.find()) {
				String charsetString = m.group(1);
				try {
					charset = Charset.forName(charsetString);
				} catch (IllegalCharsetNameException e) {
					e.printStackTrace();
				} catch (IllegalArgumentException e) {
					e.printStackTrace();
				}
			}
		}
		return charset;
	}
	 */

	@Override
	public String getAcceptedTypes() {
		return "text/html,text/plain,text/*";
	}

}
