/*
 * Copyright 2010-2015 http://beders.github.com/Resty
 * Copyright 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ej.jsonpath.parser;

import java.util.List;

import org.json.me.JSONException;
import org.json.me.JSONObject;

import ej.jsonpath.parser.JSONPathCompiler.JSONPathExpr;


public class Predicates {
	public interface Test {
		boolean test(JSONObject json) throws JSONException;
	}

	static class Operator implements Test {
		JSONPathExpr lhs;
		char ops;
		JSONPathExpr rhs;

		Operator(JSONPathExpr aSubExpr, String anOperator, JSONPathExpr aValue) {
			lhs = aSubExpr;
			ops = anOperator.charAt(0);
			rhs = aValue;
		}

		@Override
		public String toString() {
			return "" + lhs + " " + ops + " " + rhs;
		}

		@Override
		public boolean test(JSONObject json) throws JSONException {
			Object eval = lhs.eval(json);
			if (eval instanceof List) {
				List results = (List) eval;
				for (Object o : results) {
					boolean result = compare(json, (Comparable) o); // if any object from the lhs matches, good!
					if (result) {
						return true;
					}
				}
			} else {
				return compare(json, (Comparable) eval);
			}
			return false;
		}

		private boolean compare(JSONObject json, Comparable val) throws JSONException {
			if (val instanceof Number) { // fix comparison between Integers and Doubles by making sure the extracted value is a double
				val = ((Number) val).doubleValue();
			}
			if (rhs == null) { // test for existence of an attribute
				return json.has(val.toString());
			} else {
				Comparable rhsVal = (Comparable) rhs.eval(json); // TODO might also be a List!
				int comparisonResult = val.compareTo(rhsVal);
				switch (ops) {
				case '>':
					return comparisonResult > 0;
				case '=':
					return comparisonResult == 0;
				case '<':
					return comparisonResult < 0;
				}
				return false;
			}
		}
	}

	static class Existence implements Test {

		@Override
		public boolean test(JSONObject json) throws JSONException {
			//
			return false;
		}

	}

	static class Identity implements Test {
		Test child;

		Identity(Test aChild) {
			child = aChild;
		}

		@Override
		public boolean test(JSONObject json) throws JSONException {
			return child.test(json);
		}

	}
}
