/*
 * Java
 *
 *	Copyright 2025 MicroEJ Corp. All rights reserved.
 *	Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.module;

import com.microej.kf.util.control.fs.FileSystemResourcesController;
import com.microej.kf.util.control.net.NetResourcesController;
import ej.kf.Feature.State;
import ej.kf.Kernel;
import ej.kf.Module;

/**
 * Kernel module.
 *
 * Allows to collect the status of the resources used by the kernel.
 */
public class KernelModule implements SandboxedModule {
	/*
	 * Controllers of the file system and network resources used by the kernel.
	 *
	 * They are not used here to control the resources used by the kernel since the
	 * kernel has no resource limitation. We use them to only collect the resources
	 * status used by the kernel.
	 */
	/** File system resources controller. */
	private final FileSystemResourcesController fsController;
	/** Network resources controller. */
	private final NetResourcesController netController;

	/**
	 * Creates an instance of the kernel module.
	 */
	public KernelModule() {
		this.fsController = new FileSystemResourcesController(Kernel.getInstance());
		this.netController = new NetResourcesController();
	}

	@Override
	public FileSystemResourcesController getFileSystemResourceController() {
		return fsController;
	}

	@Override
	public NetResourcesController getNetworkResourceController() {
		return netController;
	}

	@Override
	public Module getModule() {
		return Kernel.getInstance();
	}

	@Override
	public String getIdentifier() {
		return Kernel.getInstance().getName();
	}

	@Override
	public State getState() {
		return State.STARTED;
	}
}