/*
 * Java
 *
 * Copyright 2021-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.aws.iot;

/**
 * AWS Iot message wrapper
 */
public class AwsIotMessage {

	private final String topic;
	private final int qos;
	private final byte[] payload;
	private final boolean retained;

	/**
	 * Create an IoT message.
	 *
	 * @param topic
	 *            MQTT topic
	 * @param qos
	 *            MQTT quality of service
	 * @param retained
	 *            should the message be retained by the MQTT broker.
	 * @param payload
	 *            message data.
	 */
	public AwsIotMessage(String topic, int qos, boolean retained, byte[] payload) {
		super();
		this.topic = topic;
		this.qos = qos;
		this.payload = payload;
		this.retained = retained;
	}

	/**
	 * Gets the topic.
	 *
	 * @return the topic.
	 */
	public String getTopic() {
		return topic;
	}

	/**
	 * Gets the payload.
	 *
	 * @return the payload.
	 */
	public byte[] getPayload() {
		return payload;
	}

	/**
	 * Gets the qos.
	 *
	 * @return the qos.
	 */
	public int getQos() {
		return qos;
	}

	/**
	 * Gets the retained.
	 *
	 * @return the retained.
	 */
	public boolean isRetained() {
		return retained;
	}

}
