/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class StartAdvertisingCommand extends Command<Boolean> {

	private final byte[] advertisementData;
	private final int advertisementDataSize;

	public StartAdvertisingCommand(byte[] advertisementData, int advertisementDataSize) {
		this.advertisementData = advertisementData;
		this.advertisementDataSize = advertisementDataSize;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_START_ADVERTISING;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendByteArray(this.advertisementData, 0, this.advertisementDataSize);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
