/*
 *	Java
 *
 *	2010-2020 ESR - Not subject to Copyright.
 *	This document has been released and published by E-S-R consortium, a non-profit entity.
 *	To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 *	The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */

package ej.microui.display;

/**
 * The interface <code>Colors</code> provides useful constants to handle RGB colors format. <br>
 * <br>
 * RGB colors format is as follow:<br>
 * | color's red level (<code>8-bit</code>) | color's green level (<code>8-bit</code>) | color's blue level (
 * <code>8-bit</code>) |<br>
 */
public final class Colors {

	/**
	 * Constant for black color.
	 */
	public static final int BLACK = 0x000000;

	/**
	 * Constant for blue color.
	 */
	public static final int BLUE = 0x0000FF;

	/**
	 * Constant for cyan color.
	 */
	public static final int CYAN = 0x00FFFF;

	/**
	 * Constant for gray color.
	 */
	public static final int GRAY = 0x808080;

	/**
	 * Constant for green color.
	 */
	public static final int GREEN = 0x008000;

	/**
	 * Constant for lime color.
	 */
	public static final int LIME = 0x00FF00;

	/**
	 * Constant for magenta color.
	 */
	public static final int MAGENTA = 0xFF00FF;

	/**
	 * Constant for maroon color.
	 */
	public static final int MAROON = 0x800000;

	/**
	 * Constant for navy color.
	 */
	public static final int NAVY = 0x000080;

	/**
	 * Constant for olive color.
	 */
	public static final int OLIVE = 0x808000;

	/**
	 * Constant for purple color.
	 */
	public static final int PURPLE = 0x800080;

	/**
	 * Constant for red color.
	 */
	public static final int RED = 0xFF0000;

	/**
	 * Constant for silver color.
	 */
	public static final int SILVER = 0xC0C0C0;

	/**
	 * Constant for teal color.
	 */
	public static final int TEAL = 0x008080;

	/**
	 * Constant for white color.
	 */
	public static final int WHITE = 0xFFFFFF;

	/**
	 * Constant for yellow color.
	 */
	public static final int YELLOW = 0xFFFF00;

	private Colors() {
		// cannot instanciate this class
	}
}
