package java.util;

/**
 * <p>
 * The root class from which all event state objects shall be derived.
 * <p>
 * All Events are constructed with a reference to the object, the "source", that is logically deemed
 * to be the object upon which the Event in question initially occurred upon.
 */
public class EventObject implements java.io.Serializable {

	/**
	 * The object on which the Event initially occurred.
	 */
	protected transient Object source;

	/**
	 * Constructs a prototypical Event.
	 *
	 * @param source
	 *        The object on which the Event initially occurred.
	 * @exception IllegalArgumentException
	 *            if source is null.
	 */
	public EventObject(Object source) {
		throw new RuntimeException();
	}

	/**
	 * The object on which the Event initially occurred.
	 *
	 * @return The object on which the Event initially occurred.
	 */
	public Object getSource() {
		throw new RuntimeException();
	}

	/**
	 * Returns a String representation of this EventObject.
	 *
	 * @return A a String representation of this EventObject.
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}
}
