package java.lang;

import ej.annotation.Nullable;

/**
 * An element in a stack trace. Each element represents a single stack frame. All stack frames
 * except for the one at the top of the stack represent a method invocation. The frame at the top of
 * the stack represents the execution point at which the stack trace was generated. Typically, this
 * is the point at which the throwable corresponding to the stack trace was created.
 */
public final class StackTraceElement implements java.io.Serializable {

	StackTraceElement() {
		throw new RuntimeException();
	}

	/**
	 * Returns true if the specified object is another {@code StackTraceElement} instance representing
	 * the same execution point as this instance. Two stack trace elements {@code a} and {@code b} are
	 * equal if and only if:
	 *
	 * <pre>
	 *     equals(a.getFileName(), b.getFileName()) &amp;&amp;
	 *     a.getLineNumber() == b.getLineNumber()) &amp;&amp;
	 *     equals(a.getClassName(), b.getClassName()) &amp;&amp;
	 *     equals(a.getMethodName(), b.getMethodName())
	 * </pre>
	 *
	 * @param obj
	 *        the object to be compared with this stack trace element.
	 * @return true if the specified object is another {@code StackTraceElement} instance representing
	 *         the same execution point as this instance.
	 */
	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Returns the fully qualified name of the class containing the execution point represented by this
	 * stack trace element.
	 *
	 * @return the fully qualified name of the {@code Class} containing the execution point represented
	 *         by this stack trace element.
	 */
	public String getClassName() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the source file containing the execution point represented by this stack
	 * trace element. Generally, this corresponds to the {@code SourceFile} attribute of the relevant
	 * {@code class} file (as per <i>The Java Virtual Machine Specification</i>, Section 4.7.7). In some
	 * systems, the name may refer to some source code unit other than a file, such as an entry in
	 * source repository.
	 *
	 * @return the name of the file containing the execution point represented by this stack trace
	 *         element, or {@code null} if this information is unavailable.
	 */
	@Nullable
	public String getFileName() {
		throw new RuntimeException();
	}

	/**
	 * Returns the line number of the source line containing the execution point represented by this
	 * stack trace element. Generally, this is derived from the {@code LineNumberTable} attribute of the
	 * relevant {@code class} file (as per <i>The Java Virtual Machine Specification</i>, Section
	 * 4.7.8).
	 *
	 * @return the line number of the source line containing the execution point represented by this
	 *         stack trace element, or a negative number if this information is unavailable.
	 */
	public int getLineNumber() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the method containing the execution point represented by this stack trace
	 * element. If the execution point is contained in an instance or class initializer, this method
	 * will return the appropriate <i>special method name</i>, {@code <init>} or {@code <clinit>}, as
	 * per Section 3.9 of <i>The Java Virtual Machine Specification</i>.
	 *
	 * @return the name of the method containing the execution point represented by this stack trace
	 *         element.
	 */
	public String getMethodName() {
		throw new RuntimeException();
	}

	/**
	 * Returns a hash code value for this stack trace element.
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns a string representation of this stack trace element. The format of this string depends on
	 * the implementation.
	 */
	@Override
	public String toString() {
		throw new RuntimeException();
	}

}
