package java.io;

import ej.annotation.Nullable;

/**
 * A <code>PrintStream</code> adds functionality to another output stream, namely the ability to
 * print representations of various data values conveniently. Two other features are provided as
 * well. Unlike other output streams, a <code>PrintStream</code> never throws an
 * <code>IOException</code>; instead, exceptional situations merely set an internal flag that can be
 * tested via the <code>checkError</code> method. Optionally, a <code>PrintStream</code> can be
 * created so as to flush automatically; this means that the <code>flush</code> method is
 * automatically invoked after a byte array is written, one of the <code>println</code> methods is
 * invoked, or a newline character or byte (<code>'\n'</code>) is written.
 *
 * <p>
 * All characters printed by a <code>PrintStream</code> are converted into bytes using the
 * platform's default character encoding.
 */
public class PrintStream extends FilterOutputStream implements Appendable, Closeable {

	/**
	 * Creates a new print stream. This stream will not flush automatically.
	 *
	 * @param out
	 *        The output stream to which values and objects will be printed
	 */
	public PrintStream(OutputStream out) {
		super(out);
		throw new RuntimeException();
	}

	/**
	 * Creates a new print stream.
	 *
	 * @param out
	 *        The output stream to which values and objects will be printed
	 * @param autoFlush
	 *        A boolean; if true, the output buffer will be flushed whenever a byte array is written,
	 *        one of the <code>println</code> methods is invoked, or a newline character or byte
	 *        (<code>'\n'</code>) is written
	 */
	public PrintStream(OutputStream out, boolean autoFlush) {
		super(out);
		throw new RuntimeException();
	}

	/**
	 * Creates a new print stream.
	 *
	 * @param out
	 *        The output stream to which values and objects will be printed
	 * @param autoFlush
	 *        A boolean; if true, the output buffer will be flushed whenever a byte array is written,
	 *        one of the <code>println</code> methods is invoked, or a newline character or byte
	 *        (<code>'\n'</code>) is written
	 * @param encoding
	 *        The name of a supported character encoding
	 *
	 * @throws UnsupportedEncodingException
	 *         If the named encoding is not supported
	 *
	 */
	public PrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
		super(out);
		throw new RuntimeException();
	}

	/**
	 * Appends the specified character to this output stream.
	 *
	 * <p>
	 * An invocation of this method of the form <tt>out.append(c)</tt> behaves in exactly the same way
	 * as the invocation
	 *
	 * <pre>
	 * out.print(c)
	 * </pre>
	 *
	 * @param c
	 *        The 16-bit character to append
	 *
	 * @return This output stream
	 */
	@Override
	public PrintStream append(char c) {
		throw new RuntimeException();
	}

	/**
	 * Appends the specified character sequence to this output stream.
	 *
	 * <p>
	 * An invocation of this method of the form <tt>out.append(csq)</tt> behaves in exactly the same way
	 * as the invocation
	 *
	 * <pre>
	 * out.print(csq.toString())
	 * </pre>
	 *
	 * <p>
	 * Depending on the specification of <tt>toString</tt> for the character sequence <tt>csq</tt>, the
	 * entire sequence may not be appended. For instance, invoking then <tt>toString</tt> method of a
	 * character buffer will return a subsequence whose content depends upon the buffer's position and
	 * limit.
	 *
	 * @param csq
	 *        The character sequence to append. If <tt>csq</tt> is <tt>null</tt>, then the four
	 *        characters <tt>"null"</tt> are appended to this output stream.
	 *
	 * @return This output stream
	 */
	@Override
	public PrintStream append(@Nullable CharSequence csq) {
		throw new RuntimeException();
	}

	/**
	 * Appends a subsequence of the specified character sequence to this output stream.
	 *
	 * <p>
	 * An invocation of this method of the form <tt>out.append(csq, start,
	 * end)</tt> when <tt>csq</tt> is not <tt>null</tt>, behaves in exactly the same way as the
	 * invocation
	 *
	 * <pre>
	 * out.print(csq.subSequence(start, end).toString())
	 * </pre>
	 *
	 * @param csq
	 *        The character sequence from which a subsequence will be appended. If <tt>csq</tt> is
	 *        <tt>null</tt>, then characters will be appended as if <tt>csq</tt> contained the four
	 *        characters <tt>"null"</tt>.
	 *
	 * @param start
	 *        The index of the first character in the subsequence
	 *
	 * @param end
	 *        The index of the character following the last character in the subsequence
	 *
	 * @return This output stream
	 *
	 * @throws IndexOutOfBoundsException
	 *         If <tt>start</tt> or <tt>end</tt> are negative, <tt>start</tt> is greater than
	 *         <tt>end</tt>, or <tt>end</tt> is greater than <tt>csq.length()</tt>
	 */
	@Override
	public PrintStream append(@Nullable CharSequence csq, int start, int end) {
		throw new RuntimeException();
	}

	/**
	 * Flushes the stream and checks its error state. The internal error state is set to
	 * <code>true</code> when the underlying output stream throws an <code>IOException</code> other than
	 * <code>InterruptedIOException</code>, and when the <code>setError</code> method is invoked. If an
	 * operation on the underlying output stream throws an <code>InterruptedIOException</code>, then the
	 * <code>PrintStream</code> converts the exception back into an interrupt by doing:
	 *
	 * <pre>
	 * Thread.currentThread().interrupt();
	 * </pre>
	 *
	 * or the equivalent.
	 *
	 * @return <code>true</code> if and only if this stream has encountered an <code>IOException</code>
	 *         other than <code>InterruptedIOException</code>, or the <code>setError</code> method has
	 *         been invoked
	 */
	public boolean checkError() {
		throw new RuntimeException();
	}

	/**
	 * Clears the internal error state of this stream.
	 *
	 * <p>
	 * This method will cause subsequent invocations of {@link #checkError()} to return <tt>false</tt>
	 * until another write operation fails and invokes {@link #setError()}.
	 */
	protected void clearError() {
		throw new RuntimeException();
	}

	/**
	 * Closes the stream. This is done by flushing the stream and then closing the underlying output
	 * stream.
	 *
	 * @see java.io.OutputStream#close()
	 */
	@Override
	public void close() {
		throw new RuntimeException();
	}

	/**
	 * Flushes the stream. This is done by writing any buffered output bytes to the underlying output
	 * stream and then flushing that stream.
	 *
	 * @see java.io.OutputStream#flush()
	 */
	@Override
	public void flush() {
		throw new RuntimeException();
	}

	/**
	 * Prints a boolean value. The string produced by <code>{@link
	 * java.lang.String#valueOf(boolean)}</code> is translated into bytes according to the platform's
	 * default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param b
	 *        The <code>boolean</code> to be printed
	 */
	public void print(boolean b) {
		throw new RuntimeException();
	}

	/**
	 * Prints a character. The character is translated into one or more bytes according to the
	 * platform's default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param c
	 *        The <code>char</code> to be printed
	 */
	public void print(char c) {
		throw new RuntimeException();
	}

	/**
	 * Prints an array of characters. The characters are converted into bytes according to the
	 * platform's default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param s
	 *        The array of chars to be printed
	 *
	 * @throws NullPointerException
	 *         If <code>s</code> is <code>null</code>
	 */
	public void print(char[] s) {
		throw new RuntimeException();
	}

	/**
	 * Prints a double-precision floating-point number. The string produced by
	 * <code>{@link java.lang.String#valueOf(double)}</code> is translated into bytes according to the
	 * platform's default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link
	 * #write(int)}</code> method.
	 *
	 * @param d
	 *        The <code>double</code> to be printed
	 * @see java.lang.Double#toString(double)
	 */
	public void print(double d) {
		throw new RuntimeException();
	}

	/**
	 * Prints a floating-point number. The string produced by <code>{@link
	 * java.lang.String#valueOf(float)}</code> is translated into bytes according to the platform's
	 * default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param f
	 *        The <code>float</code> to be printed
	 * @see java.lang.Float#toString(float)
	 */
	public void print(float f) {
		throw new RuntimeException();
	}

	/**
	 * Prints an integer. The string produced by <code>{@link
	 * java.lang.String#valueOf(int)}</code> is translated into bytes according to the platform's
	 * default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param i
	 *        The <code>int</code> to be printed
	 * @see java.lang.Integer#toString(int)
	 */
	public void print(int i) {
		throw new RuntimeException();
	}

	/**
	 * Prints a long integer. The string produced by <code>{@link
	 * java.lang.String#valueOf(long)}</code> is translated into bytes according to the platform's
	 * default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param l
	 *        The <code>long</code> to be printed
	 * @see java.lang.Long#toString(long)
	 */
	public void print(long l) {
		throw new RuntimeException();
	}

	/**
	 * Prints an object. The string produced by the <code>{@link
	 * java.lang.String#valueOf(Object)}</code> method is translated into bytes according to the
	 * platform's default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param obj
	 *        The <code>Object</code> to be printed
	 * @see java.lang.Object#toString()
	 */
	public void print(@Nullable Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Prints a string. If the argument is <code>null</code> then the string <code>"null"</code> is
	 * printed. Otherwise, the string's characters are converted into bytes according to the platform's
	 * default character encoding, and these bytes are written in exactly the manner of the
	 * <code>{@link #write(int)}</code> method.
	 *
	 * @param s
	 *        The <code>String</code> to be printed
	 */
	public void print(@Nullable String s) {
		throw new RuntimeException();
	}

	/**
	 * Terminates the current line by writing the line separator string. The line separator string is
	 * defined by the system property <code>line.separator</code>, and is not necessarily a single
	 * newline character (<code>'\n'</code>).
	 */
	public void println() {
		throw new RuntimeException();
	}

	/**
	 * Prints a boolean and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(boolean)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>boolean</code> to be printed
	 */
	public void println(boolean x) {
		throw new RuntimeException();
	}

	/**
	 * Prints a character and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(char)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>char</code> to be printed.
	 */
	public void println(char x) {
		throw new RuntimeException();
	}

	/**
	 * Prints an array of characters and then terminate the line. This method behaves as though it
	 * invokes <code>{@link #print(char[])}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        an array of chars to print.
	 */
	public void println(char[] x) {
		throw new RuntimeException();
	}

	/**
	 * Prints a double and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(double)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>double</code> to be printed.
	 */
	public void println(double x) {
		throw new RuntimeException();
	}

	/**
	 * Prints a float and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(float)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>float</code> to be printed.
	 */
	public void println(float x) {
		throw new RuntimeException();
	}

	/**
	 * Prints an integer and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(int)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>int</code> to be printed.
	 */
	public void println(int x) {
		throw new RuntimeException();
	}

	/**
	 * Prints a long and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(long)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        a The <code>long</code> to be printed.
	 */
	public void println(long x) {
		throw new RuntimeException();
	}

	/**
	 * Prints an Object and then terminate the line. This method calls at first String.valueOf(x) to get
	 * the printed object's string value, then behaves as though it invokes
	 * <code>{@link #print(String)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>Object</code> to be printed.
	 */
	public void println(@Nullable Object x) {
		throw new RuntimeException();
	}

	/**
	 * Prints a String and then terminate the line. This method behaves as though it invokes
	 * <code>{@link #print(String)}</code> and then <code>{@link #println()}</code>.
	 *
	 * @param x
	 *        The <code>String</code> to be printed.
	 */
	public void println(@Nullable String x) {
		throw new RuntimeException();
	}

	/**
	 * Sets the error state of the stream to <code>true</code>.
	 *
	 * <p>
	 * This method will cause subsequent invocations of {@link #checkError()} to return <tt>true</tt>
	 * until {@link #clearError()} is invoked.
	 */
	protected void setError() {
		throw new RuntimeException();
	}

	/**
	 * Writes <code>len</code> bytes from the specified byte array starting at offset <code>off</code>
	 * to this stream. If automatic flushing is enabled then the <code>flush</code> method will be
	 * invoked.
	 *
	 * <p>
	 * Note that the bytes will be written as given; to write characters that will be translated
	 * according to the platform's default character encoding, use the <code>print(char)</code> or
	 * <code>println(char)</code> methods.
	 *
	 * @param buf
	 *        A byte array
	 * @param off
	 *        Offset from which to start taking bytes
	 * @param len
	 *        Number of bytes to write
	 */
	@Override
	public void write(byte[] buf, int off, int len) {
		throw new RuntimeException();
	}

	/**
	 * Writes the specified byte to this stream. If the byte is a newline and automatic flushing is
	 * enabled then the <code>flush</code> method will be invoked.
	 *
	 * <p>
	 * Note that the byte is written as given; to write a character that will be translated according to
	 * the platform's default character encoding, use the <code>print(char)</code> or
	 * <code>println(char)</code> methods.
	 *
	 * @param b
	 *        The byte to be written
	 * @see #print(char)
	 * @see #println(char)
	 */
	@Override
	public void write(int b) {
		throw new RuntimeException();
	}
}