/*
 * Java
 *
 * Copyright 2014-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.util;

import ej.microui.event.Event;
import ej.microui.event.controller.DispatchHelper;

/**
 * An event handler is intended to receive and handle events.
 * <p>
 * In the MVC pattern it is the controller.
 *
 * @since 2.0
 */
public interface EventHandler {

	/**
	 * Handles an event.
	 *
	 * @param event
	 *            the event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 *
	 * @see Event
	 * @see DispatchHelper
	 */
	boolean handleEvent(int event);

}
