/*
 * Java
 *
 * Copyright 2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.controller;

import ej.microui.event.Event;

/**
 * Event handler that manages MicroUI events type.
 *
 * @see Event
 * @since 2.0
 */
public interface EventGeneratorsHandler {

	/**
	 * Handles button events.
	 *
	 * @param event
	 *            the button event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean handleButton(int event);

	/**
	 * Handles command events.
	 *
	 * @param event
	 *            the command event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean handleCommand(int event);

	/**
	 * Handles keyboard events.
	 *
	 * @param event
	 *            the keyboard event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean handleKeyboard(int event);

	/**
	 * Handles keypad events.
	 *
	 * @param event
	 *            the keypad event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean handleKeypad(int event);

	/**
	 * Handles pointer events.
	 *
	 * @param event
	 *            the pointer event to handle.
	 * @return <code>true</code> if the event is consumed, <code>false</code> otherwise.
	 */
	boolean handlePointer(int event);

}
