/*
 *	Java
 *
 *	Copyright 2015-2017 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.shape;

import ej.microui.display.GraphicsContext;

/**
 * The {@link AntiAliasedShapes} class offers advanced drawing facilities, to render anti aliased lines, circles etc.
 * <br>
 * <br>
 * An {@link AntiAliasedShapes} instance holds a global state (thickness and fade) for all drawings. Several
 * {@link AntiAliasedShapes} instances can be created at same time. However a default instance is created on MicroUI
 * framework startup and it always available.<br>
 *
 * @since 2.0
 */
public class AntiAliasedShapes {

	/**
	 * Default {@link AntiAliasedShapes} instance created on MicroUI framework startup.
	 */
	public static AntiAliasedShapes Singleton = new AntiAliasedShapes();

	/**
	 * Define the cap representation when drawing a circle arc
	 *
	 * @see #setStartCap(Cap)
	 * @see #setEndCap(Cap)
	 * @see #setCaps(Cap, Cap)
	 * @see #drawCircleArc(GraphicsContext, int, int, int, int, int)
	 */
	public enum Cap {

		/**
		 * No specific cap is drawn
		 */
		NONE(0),

		/**
		 * Cap is represented by a semi circle (default configuration)
		 */
		ROUNDED(1),

		/**
		 * Cap is perpendicular to the line
		 */
		PERPENDICULAR(2),

		// not available yet
		// HORIZONTAL(3),
		// VERTICAL(4),
		;

		private Cap(int val) {
			throw new RuntimeException();
		}
	}

	/**
	 * Creates a new {@link AntiAliasedShapes} instance. The global state is set to its initial value.
	 *
	 * @see #reset()
	 */
	public AntiAliasedShapes() {
		throw new RuntimeException();
	}

	/**
	 * Resets the {@link AntiAliasedShapes} global state to its initial values. Default <code>fade</code> is 1 and
	 * default <code>thickness</code> is 0.
	 */
	public void reset() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current <code>fade</code>.
	 *
	 * @return the current <code>fade</code>.
	 */
	public int getFade() {
		throw new RuntimeException();
	}

	/**
	 * Apply a new <code>fade</code>.
	 *
	 * @param fade
	 *            the new fade to apply.
	 * @throws IllegalArgumentException
	 *             when given fade is negative
	 */
	public void setFade(int fade) {
		throw new RuntimeException();
	}

	/**
	 * Returns the current <code>thickness</code>.
	 *
	 * @return the current <code>thickness</code>.
	 */
	public int getThickness() {
		throw new RuntimeException();
	}

	/**
	 * Apply a new <code>thickness</code>.
	 *
	 * @param thickness
	 *            the new thickness to apply.
	 * @throws IllegalArgumentException
	 *             when given thickness is negative
	 */
	public void setThickness(int thickness) {
		throw new RuntimeException();
	}

	/**
	 * Returns the current shape start cap.
	 *
	 * @return the current shape start cap.
	 */
	public Cap getStartCap() {
		throw new RuntimeException();
	}

	/**
	 * Configures the cap representation of start of shape. This configuration is used by
	 * {@link #drawCircleArc(GraphicsContext, int, int, int, int, int)}.
	 *
	 * @param cap
	 *            the shape cap configuration
	 */
	public void setStartCap(Cap cap) {
		throw new RuntimeException();
	}

	/**
	 * Returns the current shape end cap.
	 *
	 * @return the current shape end cap.
	 */
	public Cap getEndCap() {
		throw new RuntimeException();
	}

	/**
	 * Configures the cap representation of end of shape. This configuration is used by
	 * {@link #drawCircleArc(GraphicsContext, int, int, int, int, int)}.
	 *
	 * @param cap
	 *            the shape cap configuration
	 */
	public void setEndCap(Cap cap) {
		throw new RuntimeException();
	}

	/**
	 * Configures the caps representation. This configuration is used by
	 * {@link #drawCircleArc(GraphicsContext, int, int, int, int, int)}. It is equivalent to the following code
	 * sequence:<br>
	 * <code>setStartCap(start);</code><br>
	 * <code>setEndCap(end);</code><br>
	 * <br>
	 *
	 * @param start
	 *            the shape cap configuration
	 * @param end
	 *            the shape cap configuration
	 */
	public void setCaps(Cap start, Cap end) {
		throw new RuntimeException();
	}

	/**
	 * Draws a point at <code>(x,y)</code> using the {@link GraphicsContext}'s current color.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x
	 *            the x coordinate of the point
	 * @param y
	 *            the y coordinate of the point
	 */
	public void drawPoint(GraphicsContext gc, int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Draws a line from <code>(x1,y1)</code> to <code>(x2,y2)</code> using the {@link GraphicsContext}'s current color.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x1
	 *            the x coordinate of the start of the line
	 * @param y1
	 *            the y coordinate of the start of the line
	 * @param x2
	 *            the x coordinate of the end of the line
	 * @param y2
	 *            the y coordinate of the end of the line
	 */
	public void drawLine(GraphicsContext gc, int x1, int y1, int x2, int y2) {
		throw new RuntimeException();
	}

	/**
	 * Draws the outline of a circular arc covering the specified square, using the current color, stroke style and caps
	 * <br>
	 * <br>
	 * The arc is drawn from <code>startAngle</code> up to <code>arcAngle</code> degrees. The center of the arc is
	 * defined as the center of the rectangle whose origin is at <code>(x,y)</code> (upper-left corner) and whose
	 * dimension is given by <code>diameter</code>.<br>
	 * <br>
	 * Angles are interpreted such that 0 degrees is at the 3 o'clock position. A positive value indicates a
	 * counter-clockwise rotation while a negative value indicates a clockwise rotation.<br>
	 * <br>
	 * If <code>diameter</code> is negative, nothing is drawn.<br>
	 * <br>
	 * The angles are given relative to the rectangle. For instance an angle of 45 degrees is always defined by the line
	 * from the center of the rectangle to the upper right corner of the rectangle. Thus for a non squarred rectangle
	 * angles are skewed along either height or width.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x
	 *            the x coordinate of the upper-left corner of the rectangle where the arc is drawn
	 * @param y
	 *            the y coordinate of the upper-left corner of the rectangle where the arc is drawn
	 * @param diameter
	 *            the diameter of the arc to draw
	 * @param startAngle
	 *            the beginning angle of the arc to draw
	 * @param arcAngle
	 *            the angular extent of the arc from <code>startAngle</code>
	 *
	 * @see #setStartCap(Cap)
	 * @see #setEndCap(Cap)
	 * @see #setCaps(Cap, Cap)
	 */
	public final void drawCircleArc(GraphicsContext gc, int x, int y, int diameter, int startAngle, int arcAngle) {
		throw new RuntimeException();
	}

	/**
	 * Draws the outline of a circle covering the rectangle specified by its diameter, using the {@link GraphicsContext}
	 * 's current color.<br>
	 * <br>
	 * The center of the circle is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is given by <code>diameter</code>.<br>
	 * <br>
	 * If <code>diameter</code> is negative, nothing is drawn.<br>
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x
	 *            the x coordinate of the upper-left corner of the rectangle where the circle is drawn
	 * @param y
	 *            the y coordinate of the upper-left corner of the rectangle where the circle is drawn
	 * @param diameter
	 *            the diameter of the circle to draw
	 */
	public void drawCircle(GraphicsContext gc, int x, int y, int diameter) {
		throw new RuntimeException();
	}

	/**
	 * Draws the outline of a ellipse covering the specified rectangle, using the {@link GraphicsContext}'s current
	 * color.<br>
	 * <br>
	 * The center of the ellipse is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is given by <code>width</code> and <code>height</code>.<br>
	 * <br>
	 * If either <code>width</code> or <code>height</code> is negative, nothing is drawn.<br>
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x
	 *            the x coordinate of the upper-left corner of the rectangle where the ellipse is drawn
	 * @param y
	 *            the y coordinate of the upper-left corner of the rectangle where the ellipse is drawn
	 * @param width
	 *            the width of the ellipse to draw
	 * @param height
	 *            the height of the ellipse to draw
	 */
	public void drawEllipse(GraphicsContext gc, int x, int y, int width, int height) {
		throw new RuntimeException();
	}
}
