/*
 * Java
 *
 * Copyright 2010-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui;

/**
 * The <code>MicroUI</code> class offers basic services in the MicroUI implementation.<br>
 * MicroUI is started explicitly by calling {@link #start()}. MicroUI may also be stopped with {@link #stop()}.
 * <p>
 * Uncaught user errors may be handled defining an {@link UncaughtExceptionHandler}.
 */
public abstract class MicroUI {

	/**
	 * Forbidden constructor: cannot instantiate a <code>MicroUI</code> object.
	 */
	private MicroUI() {
	}

	/**
	 * Starts MicroUI.<br>
	 * It implies starting event serialization as well as rendering mechanisms.<br>
	 * This method does nothing if MicroUI is already started.<br>
	 *
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to start MicroUI.
	 */
	public static void start() throws SecurityException {
		throw new RuntimeException();
	}

	/**
	 * Stops MicroUI.<br>
	 * It implies stopping any potential event serialization as well as rendering mechanisms.<br>
	 * This method does nothing if MicroUI is already stopped.<br>
	 *
	 * @throws SecurityException
	 *             if a security manager exists and does not allow the caller to stop MicroUI.
	 */
	public static void stop() throws SecurityException {
		throw new RuntimeException();
	}

	/**
	 * Checks if MicroUI has been started.<br>
	 * 
	 * @return true when MicroUI is running.
	 */
	public static boolean isStarted() {
		throw new RuntimeException();
	}

	/**
	 * Sets the exception handler called when an exception occurred in the library.
	 * <p>
	 * When no handler is defined, the exception stack trace is printed on standard error stream.
	 *
	 * @param exceptionHandler
	 *            the handler to use when an exception occurred in the library.
	 * @see System#err
	 * @since 2.0
	 */
	public static final void setUncaughtExceptionHandler(UncaughtExceptionHandler exceptionHandler) {
		throw new RuntimeException();
	}

}
