/*
 * Java
 *
 * Copyright 2015-2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.microui;

import java.security.Permission;

import ej.annotation.Nullable;

/**
 * This class is for MicroUI permissions.
 * <p>
 * The name is related to the MicroUI APIs and it symbolizes the permission's action.
 * <p>
 * The meaning of the possible permissions is defined as follows:
 * <dl>
 * <dt>start
 * <dd>start permission. Allows <code>MicroUI.start()</code> to be called.
 * <dt>stop
 * <dd>stop permission. Allows <code>MicroUI.stop()</code> to be called.
 * </dl>
 *
 * @see java.security.Permission
 */
public class MicroUIPermission extends Permission {

	/**
	 * Permission to start MicroUI.
	 */
	public static final String ACTION_START = "start"; //$NON-NLS-1$

	/**
	 * Permission to stop MicroUI.
	 */
	public static final String ACTION_STOP = "stop"; //$NON-NLS-1$

	/**
	 * Creates a permission with the specified name.
	 *
	 * @param permission
	 *            the name of the <code>MicroUIPermission</code>.
	 */
	public MicroUIPermission(String permission) {
		super(null);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
