/*
 * Java
 *
 * Copyright 2013-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.security;

import java.security.Permission;

import ej.kf.Feature;

/**
 * API for checking {@link Feature} permissions.
 */
public interface FeaturePermissionCheckDelegate {

	/**
	 * Called by {@link KernelSecurityManager} when the current thread context requesting for a Permission check is
	 * owned by a Feature. This method is called in Kernel mode.
	 * 
	 * @param p
	 *            the permission to check
	 * @param f
	 *            the feature which own the permission
	 */
	public void checkPermission(Permission p, Feature f);
}