/*
 * Java
 *
 * Copyright 2015-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util;

import org.eclipse.core.runtime.IProgressMonitor;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;
import ej.kf.Proxy;

public class IProgressMonitorConverter implements Converter<IProgressMonitor> {

	@Override
	public IProgressMonitor convert(IProgressMonitor arg0, Feature arg1) throws IllegalAccessError {
		final Proxy<IProgressMonitor> ref = Kernel.newProxy(arg0, arg1);
		final IProgressMonitor[] result = new IProgressMonitor[1];
		Kernel.runUnderContext(arg1, new Runnable() {

			@Override
			public void run() {
				IProgressMonitorProxy p = new IProgressMonitorProxy(ref);
				Kernel.enter();
				result[0] = p;
			}
		});
		return result[0];
	}

	@Override
	public Class<IProgressMonitor> getType() {
		return IProgressMonitor.class;
	}

}