/*
 * Copyright 2013-2014 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.util.logging;

/**
 * A handler is an entity that publishes messages.
 * <p>
 * It may simply write messages to the standard output or a file, send it through a network, etc.
 */
public abstract class Handler {

	/**
	 * Close the handler and the associated resources (such as streams, connections, files).
	 * <p>
	 * NOTE: this method is not called by the framework.
	 * 
	 * @throws SecurityException
	 *             if a security manager exits and if the caller does not have the appropriate permissions.
	 */
	public abstract void close() throws SecurityException;

	/**
	 * Flush any buffered output.
	 * <p>
	 * NOTE: this method is not called by the framework.
	 */
	public abstract void flush();

	/**
	 * Publish a LogRecord. The logging request was made initially to a logger, which forwarded the LogRecord to the handler if the logger's
	 * level was compatible.
	 * 
	 * @param record
	 *            the LogRecord to publish.
	 */
	public abstract void publish(LogRecord record);
}
