/*
 * Java
 *
 * Copyright 2010-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt;

/**
 * This class defines standard flags to use in bit-fields.
 */
public interface MWT {

	/**
	 * Constant equals to <code>-1</code>.
	 */
	public static final int ERROR = -1; // NOSONAR

	/**
	 * Constant equals to <code>-1</code>.
	 */
	public static final int EMPTY = -1; // NOSONAR

	/**
	 * Constant equals to zero used to put and check that no flags are set.
	 */
	public static final int NONE = 0; // NOSONAR

	/**
	 * Constant for alignment or direction behavior.
	 */
	public static final int NORTH = 1 << 0; // NOSONAR
	/**
	 * Constant for alignment or direction behavior.
	 */
	public static final int SOUTH = 1 << 1; // NOSONAR
	/**
	 * Constant for alignment or direction behavior.
	 */
	public static final int WEST = 1 << 2; // NOSONAR
	/**
	 * Constant for alignment or direction behavior.
	 */
	public static final int EAST = 1 << 3; // NOSONAR
	/**
	 * Constant for alignment or direction behavior.
	 */
	public static final int CENTER = 1 << 4; // NOSONAR

	/**
	 * Constant for direction behavior. (Same as {@link MWT#NORTH})
	 */
	public static final int UP = NORTH; // NOSONAR
	/**
	 * Constant for direction behavior. (Same as {@link MWT#SOUTH})
	 */
	public static final int DOWN = SOUTH; // NOSONAR
	/**
	 * Constant for direction behavior. (Same as {@link MWT#WEST})
	 */
	public static final int LEAD = WEST; // NOSONAR
	/**
	 * Constant for direction behavior. (Same as {@link MWT#EAST})
	 */
	public static final int TRAIL = EAST; // NOSONAR

	/**
	 * Constant for alignment behavior. (Same as {@link MWT#NORTH})
	 */
	public static final int TOP = NORTH; // NOSONAR
	/**
	 * Constant for alignment behavior. (Same as {@link MWT#SOUTH})
	 */
	public static final int BOTTOM = SOUTH; // NOSONAR
	/**
	 * Constant for alignment behavior. (Same as {@link MWT#WEST})
	 */
	public static final int LEFT = WEST; // NOSONAR
	/**
	 * Constant for alignment behavior. (Same as {@link MWT#EAST})
	 */
	public static final int RIGHT = EAST; // NOSONAR
	/**
	 * Constant for alignment behavior.
	 */
	public static final int HCENTER = 1 << 5; // NOSONAR
	/**
	 * Constant for alignment behavior.
	 */
	public static final int VCENTER = 1 << 6; // NOSONAR

	/**
	 * Constant for alignment or orientation behavior.
	 */
	public static final int HORIZONTAL = 1 << 7; // NOSONAR
	/**
	 * Constant for alignment or orientation behavior.
	 */
	public static final int VERTICAL = 1 << 8; // NOSONAR

	/**
	 * Constant for scrolling behavior.
	 */
	public static final int HSCROLL = HORIZONTAL; // NOSONAR
	/**
	 * Constant for scrolling behavior.
	 */
	public static final int VSCROLL = VERTICAL; // NOSONAR

	/**
	 * Constant for uniqueness.
	 */
	public static final int SINGLE = 1 << 9; // NOSONAR
	/**
	 * Constant for multiplicity.
	 */
	public static final int MULTI = 1 << 10; // NOSONAR
	/**
	 * Constant for wrapping behavior.
	 */
	public static final int WRAP = 1 << 11; // NOSONAR

}
