# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.10.3] - 2025-01-16

### Fixed

  - Test files may be ignored when several test source folders are defined.

## [1.10.2] - 2024-11-12

### Fixed

  - `@Before*` and `@After*` methods were not transitively called in class hierarchy.

## [1.10.1] - 2024-08-23

### Fixed

  - Backward compatibility with tests generated with JUnit prior to 1.10.0. 

## [1.10.0] - 2024-06-27

### Added

  - Allow skipping single tests with properties.

### Changed

  - Rework the test output to separate test cases and print skipped tests.

### Fixed

  - `_AllTestClasses.java` not generated in the right directory.
  - Call super class tests when they exist.
  - Eclipse errors during build when tests use UTF-8 characters.

## [1.9.0] - 2024-05-21

### Changed

  - Make test file generation incremental.

## [1.8.0] - 2024-04-11

### Added

  - Add the `Assume` class that ignores tests if an assumption fails.

## [1.7.1] - 2020-05-11

### Fixed

  - Fix non generated call to SimpleTestMethods in the generated "_AllTests_MyClassTest.java" files.

## [1.7.0] - 2020-05-06

### Added

  - @RepeatedTest(value) annotation that repeats a test a number of time equals to the value.

## [1.6.2] - 2020-01-17

### Fixed

  - Fixed NullPointerException when a class has no import declaration.

## [1.6.1] - 2019-12-18

### Fixed

  - Empty parent class now gives access to grandparent annotated methods for child class.
  - Annotation @Test() with empty parenthesis error.
  
## [1.6.0] - 2019-12-10

### Added

  - Processor now takes parent classes annotated methods into account for subclasses.

## [1.5.0] - 2019-03-07

### Changed

  - use MMM.

## [1.4.2] - 2018-09-17

### Fixed

  - Generation fails with NullPointerException when the project does not contain any test.

## [1.4.1] - 2018-09-14

### Fixed

  - Generation fails with ArrayIndexOutOfBoundsException when tests are in several packages.

## [1.4.0] - 2018-09-07

### Added

  - Generate class that runs all tests from all classes.
  - Align with processor version.

## [1.2.0] - 2017-09-06

### Added

  - Improved Wrapper API and generated code so it can be used from apps, possibly through a SharedInterface.	

## [1.1.0] - 2017-01-25

### Added

  - WI18782 Add support for Ignore annotation.

## [1.0.2] - 2016-16-26

### Fixed

  - WI18427 Upgrade the junit-processor.

## [1.0.1] - 2016-12-09

### Added

  - WI18408 Update readme.

## [1.0.0] - 2016-10-24

### Added

  - Initial revision.

---  
_Copyright 2015-2025 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp._  
