# Overview

This library implements an SNTP client. It can be used to retrieve the current time from an NTP server.

SNTP is a lightweight specification of NTP client/server, made for embedded, fully compatible with the NTP infrastructure widely available on the Internet.

For more details on SNTP, refer to the [RFC 5905](https://tools.ietf.org/html/rfc5905#section-14).

This implementation is derived from the [Android implementation](https://android.googlesource.com/platform/frameworks/base.git/+/456069019eb4da612ddf5c32a927797750e2847e/core/java/android/net/SntpClient.java).
It is part of the core code base but it is not part of Android's API.

# Usage

Add the following line to your `module.ivy`:
	
    <dependency org="ej.library.iot" name="sntpclient" rev="1.2.0"/>

**Warning:** Note that this library doesn't limit the rate of the requests sent.
It is the responsibility of the user to limit calls to `SntpClient.requestTime()` and to respect the guard time of the server used ([typically 2s](http://doc.ntp.org/4.2.6p1/rate.html)).
	
# Requirements

This library requires the following Foundation Libraries:

    BON-1.3, EDC-1.2, NET-1.1

# Dependencies

_All dependencies are retrieved transitively by Ivy resolver._

# Source

N/A

# Restrictions

None.

---  
_Copyright 2017-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
