# Overview
MicroPaho - MQTT Client is MicroEJ Add-on Library for MQTT protocol communication.

MicroPaho is a tiny MQTT client running on MicroEJ, inspired from Eclipse Paho Java & Embedded C implementations. 

This library has been designed with the following key points in mind:

* Keep well known APIs defined by the Paho Java implementation. Most of the existing Java applications using Paho Java implementation can be migrated in few minutes with minor updates.
* Simple, efficient and tiny code inspired by the Paho Embedded C implementation:

  * At least one action at a time (connect, publish, subscribe, disconnect) so that there is at most one pending acknowledgment to wait for.
  * Minimum dependencies to external libraries
  
* Implements only features of the MQTT specification required to connect production grade MQTT servers. The most noticeable feature which is not supported by this library is QoS 2.

# Usage
Add the following line to your `module.ivy`:

    <dependency org="ej.library.iot" name="micropaho" rev="1.0.0"/>

# Requirements
This library requires the following Foundation Libraries to be provided by the MicroEJ VEE:

    BON-1.4, EDC-1.3, NET-1.1, TRACE-1.1

# Dependencies
All dependencies are retrieved transitively by MicroEJ Module Manager.

# Source
This software has been derived from:

- Eclipse Paho Java, commit ID ``5af7b53499e7dbe45b7227b3d41fc870089c0033``
- Eclipse Paho Embedded C, commit ID ``07bf54a3f4a93121a018edb6981facc85e566f27``

# Tests
* To Run the tests, a running docker process is required on the test host. 
* Docker version >= ``20.10.8``

MicroPaho is tested at build time against a local ``Mosquitto`` server. 

The project is configured to start/stop an ``eclipse-mosquitto:1.6.15`` docker container before running/terminating the tests execution. 

The docker image is automatically pulled from [docker hub](https://hub.docker.com/_/eclipse-mosquitto).


MicroPaho has been successfully tested to connect [AWS IoT Core server](https://aws.amazon.com/fr/iot-core/).

# Memory Requirements
This section provides some measurements giving a good idea of the library memory requirements.
The values are given as an indication and are subject to slightly change from versions to versions.

## Code Memory Consumption
MicroPaho code memory consumption is approximately ``5.5KB``. 

It has been measured using the [Memory Map Analyzer](https://docs.microej.com/en/latest/ApplicationDeveloperGuide/memoryMapAnalyzer.html) 
on the [WROVER 4.1 Platform](https://github.com/MicroEJ/Platform-Espressif-ESP-WROVER-KIT-V4.1) based on Xtensa LX6 Architecture version ``7.16.0``.   

The original ``SOAR.map`` file can be found [here](./memoryrequirements/SOAR.map) and can be browsed using the Memory Map Analyzer in the MicroEJ SDK.

## Heap Memory Consumption
MicroPaho heap memory consumption is approximately ``2KB`` 
(from the ``MqttConnectOptions`` object creation to a message received in the ``MqttCallback.messageArrived`` callback).

It has been measured to 1.9KB using the MicroEJ Simulator 
on a Platform based on CM4/GCC Architecture version ``7.11.0`` and NET Pack version ``8.1.6``.

## Thread and Stack Consumption
MicroPaho requires one thread to dispatch incoming events and to regularly send the ``Keep Alive`` message 
when it is enabled. 

The thread requires less than ``1`` stack block of ``512`` bytes for its internal execution.

Obviously, the thread may require more than one stack block depending on the depth of 
the application callback call stack.

## External Dependencies
MicroPaho depends on approximately ``25`` types and ``60`` methods.

At the time this file has been wrote, here is the list of the required types: 

```

	ej/bon/Constants
	ej/bon/Immutables
	ej/bon/Util
	ej/trace/Tracer
	java/io/EOFException
	java/io/InputStream
	java/io/OutputStream
	java/lang/AssertionError
	java/lang/AutoCloseable
	java/lang/Class
	java/lang/IllegalArgumentException
	java/lang/Integer
	java/lang/Object
	java/lang/Runnable
	java/lang/RuntimeException
	java/lang/String
	java/lang/StringBuilder
	java/lang/Thread
	java/lang/Throwable
	java/net/InetSocketAddress
	java/net/Socket
	javax/net/SocketFactory
```

# Restrictions
The following features specified by MQTT ``3.1.1`` are not supported by this client:

* Other MQTT versions than ``3.1.1``
* Clean Session 0
* QoS 2
* Will messages
* Multiple in-flight messages

The following features specified by the Eclipse Paho Java API are not supported by this client:

* The callback method ``org.eclipse.paho.client.mqttv3.MqttCallback.messageArrive`` specification has been modified:

  * when QoS is 1, the message acknowledgment is sent before the callback method is executed, thus the message is acknowledged even if an exception is thrown by the callback
  * within an implementation of this callback, it is not possible to send a new message. Only the following methods are allowed to be called:

    - ``org.eclipse.paho.client.mqttv3.IMqttClient.getClientId()``
    - ``org.eclipse.paho.client.mqttv3.IMqttClient.getServerURI()``
    - ``org.eclipse.paho.client.mqttv3.IMqttClient.isConnected()``

* The method ``org.eclipse.paho.client.mqttv3.MqttCallback.deliveryComplete(IMqttDeliveryToken)`` has been removed.
* No topic format validation in ``publish`` and ``subscribe`` methods 

# Constants
* ``micropaho.server.check`` enable additional consistency checks on the data received from the MQTT server. default is `true`
* ``micropaho.thread.priority`` allow to customize the MQTT receiver thread priority. default is ``5``
* ``micropaho.debug`` enable debug mode and activate traces. default is ``false``

[see B-ON constants documentation](https://docs.microej.com/en/latest/ApplicationDeveloperGuide/classpath.html#constants)
     
---
_Copyright 2019-2021 MicroEJ Corp. All rights reserved._
_This library is provided in source code for use, modification and test, subject to license terms._
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._     