# Overview

This library contains the implementation of an HTTPS client.

# Usage

Add the following line to your `module.ivy`:
	
    <dependency org="ej.library.eclasspath" name="httpsclient" rev="1.3.0"/>
	
## Memory tuning

Override the following BON Constants to tune the buffer size:

- `java.net.HttpURLConnection.rx.buffer.size` (default value = 8192, minimum value = 10).
- `java.net.HttpURLConnection.tx.buffer.size` (default value = 8192, minimum value = 0).

When they are set to 0, only the BSP buffer will be used.

# Requirements

This library requires the following Foundation Libraries:

    BON-1.4, EDC-1.3, NET-1.1, SECURITY-1.3, SSL-2.2

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

  - Open JDK 8u20

# Restrictions

  - Removed java.net.Proxy dependency and proxy tunneling connection
  - Removed response caching
  - Removed cache request management
  - Removed certificates and keys management
  - Removed server identity checking out of SSLSocket
  - Removed javax.net.ssl.HostnameVerifier dependency
  

---  
_Markdown_  
_Copyright 2015-2020 MicroEJ Corp. - EDC compliance and optimizations._  
_DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER._  
_ _  
_This code is free software; you can redistribute it and/or modify it_  
_under the terms of the GNU General Public License version 2 only, as_  
_published by the Free Software Foundation._  
_ _  
_This code is distributed in the hope that it will be useful, but WITHOUT_  
_ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or_  
_FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License_  
_version 2 for more details (a copy is included in the LICENSE file that_  
_accompanied this code)._  
_ _  
_You should have received a copy of the GNU General Public License version_  
_2 along with this work; if not, write to the Free Software Foundation,_  
_Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA._  
_ _  
_Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA_  
_or visit www.oracle.com if you need additional information or have any_  
_questions._  