# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.7.0] - 2023-05-17

### Changed

  - Update `LICENSE.txt` to latest SDK/BSD license and copyright headers accordingly.

### Added

- Add an API to set the maximum amount of memory heap that can be allocated by a Feature: `Feature.setMemoryLimit()`, `Feature.getMemoryLimit()`.
- Add an API to set the minimum amount of memory heap reserved for the Kernel: `Kernel.setReservedMemory()`, `Kernel.getReservedMemory()`.
- Add an API to retrieve the amount of memory allocated by a module (Kernel or Feature): `Module.getAllocatedMemory()`.
- Add an API to load a resource stored in a Feature: `Feature.getResourceAsStream()`.

### Changed

  - Improve `Kernel.setUncaughtExceptionHandler()` Javadoc.
  
### Fixed

  - Clarify behavior when `Feature.getCriticality()` and `Feature.setCriticality()` is called on an uninstalled Feature. 
    In such a case, the method throws an `IllegalStateException`.

## [1.6.1] - 2022-03-14

### Changed

  - Migrate module to MMM
  - Update `LICENSE.txt` to latest ESR license 

## [1.6.0] - 2021-07-29

### Added

  - Add an API to know if a Feature can be uninstalled: `Kernel.canUninstall()`.

## [1.5.1] - 2021-03-25

### Added

  - Mark APIs for Null Analysis
  
### Fixed

  - Make `Module` constructor private
 

## [1.5.0] - 2021-03-11

### Added

  - Add Memory Control support with the following API:
    - `ej.kf.Feature.getCriticality()`
    - `ej.kf.Feature.setCriticality()`
    - `ej.kf.Feature.MIN_CRITICALITY`
    - `ej.kf.Feature.NORM_CRITICALITY`
    - `ej.kf.Feature.MAX_CRITICALITY`
    - `ej.kf.Kernel.addResourceControlListener()`
    - `ej.kf.Kernel.removeResourceControlListener()`
    - `ej.kf.ResourceControlListener`
  
### Fixed

  - Fix following methods can throw an `IllegalStateException` if the referenced Feature is not started:
    - `Kernel.runUnderContext()`
    - `Kernel.setOwner()`
    - `Kernel.clone()`
    - `Kernel.bind()`
    - `Kernel.newProxy()`

## [1.4.4] - 2018-09-21

### Fixed

  - Remove unused API `Kernel.setOwner` which is not in ESR specifications.

## [1.4.3] - 2017-02-21

### Fixed

  - Bad signature of `ej.kf.Proxy.invokeFloat`.

## [1.4.2] - 2016-04-01

### Added

  - Initial public revision.

---
_Markdown_  
_Copyright 2016-2023 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  