# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## 2.1.1 - 2021-07-08

### Added
  - Add information on the features of this API in the readme file.

### Changed
  - Update edc dependency to version 1.3.3.

## 2.1.0 - 2020-11-27

### Added
  - Add constructor to `BluetoothAddress` with byte array parameter.
  - Add constructor to `BluetoothUuid` with byte array parameter.
  - Add method `BluetoothAddress.getBytes`.
  - Add method `BluetoothAddress.hashCode`.
  - Add method `BluetoothUuid.getBytes`.
  - Add method `BluetoothUuid.is16Bit`.
  - Add method `BluetoothUuid.get16BitValue`.
  - Add method `BluetoothUuid.hashCode`.

## 2.0.0 - 2020-05-04

### Added
  - Add class `BluetoothAddress`.
  - Add class `BluetoothDataTypes`.
  - Add class `BluetoothScanFilter`.
  - Add class `BluetoothServiceDefinition`.
  - Add method `BluetoothAdapter.enable`.
  - Add method `BluetoothAdapter.disable`.
  - Add method `BluetoothAdapter.setConnectionListener`.
  - Add method `BluetoothConnection.discoverService`.
  - Add method `BluetoothService.getNumCharacteristics`.
  - Add method `BluetoothService.getCharacteristic`.
  - Add method `BluetoothCharacteristic.getNumDescriptors`.
  - Add method `BluetoothCharacteristic.getDescriptor`.
  - Add annotations for null analysis.

### Changed
  - Rename class `BluetoothDevice` to `BluetoothConnection`.
  - Merge interfaces `ConnectionCallbacks`, `AdvertisementCallbacks` and `ScanCallbacks` into `ConnectionListener`.
  - Rename interface `ServerCallbacks` to `LocalServiceListener`.
  - Rename interface `ClientCallbacks` to `RemoteServiceListener`.
  - Rename class `DefaultConnectionCallbacks` to `DefaultConnectionListener`.
  - Rename class `DefaultServerCallbacks` to `DefaultLocalServiceListener`.
  - Rename class `DefaultClientCallbacks` to `DefaultRemoteServiceListener`.
  - Refactor interface `BluetoothPermissions` into a class.
  - Refactor interface `BluetoothProperties` into a class.
  - Refactor interface `BluetoothStatus` into a class.
  - Make constructor `BluetoothService` private.
  - Rename method `BluetoothAdapter.getDefaultAdapter` to `getAdapter`.
  - Move method `BluetoothDevice.connect` to `BluetoothAdapter`.
  - Rename method `BluetoothDevice.pair` to `sendPairRequest`.
  - Rename method `BluetoothDevice.pairReply` to `sendPairResponse`.
  - Rename method `BluetoothDevice.passkeyReply` to `sendPasskeyResponse`.
  - Rename method `BluetoothService.setClientCallbacks` to `setRemoteListener`.
  - Rename method `BluetoothService.setServerCallbacks` to `setLocalListener`.
  - Move method `BluetoothAttribute.sendReadRequest` to `BluetoothConnection`.
  - Move method `BluetoothAttribute.sendWriteRequest` to `BluetoothConnection`.
  - Move method `BluetoothAttribute.sendReadResponse` to `BluetoothConnection`.
  - Move method `BluetoothAttribute.sendWriteResponse` to `BluetoothConnection`.
  - Move method `BluetoothCharacteristic.sendNotification` to `BluetoothConnection`.
  - Use `byte` instead of `int` for permissions, properties and status.
  - Update edc dependency to version 1.3.0.
  - Update license file.

### Removed
  - Remove enum `BluetoothService.Type`.
  - Remove method `BluetoothAdapter.getConnectedDevices`.
  - Remove method `BluetoothAdapter.getDevices`.
  - Remove method `BluetoothAdapter.cleanupDevices`.
  - Remove method `BluetoothAdapter.getServices`.
  - Remove method `BluetoothAdapter.isScanning`.
  - Remove method `BluetoothAdapter.isAdvertising`.
  - Remove method `BluetoothDevice.isConnected`.
  - Remove method `BluetoothService.getType`.
  - Remove method `BluetoothService.addIncludedService`.
  - Remove method `BluetoothService.getIncludedServices`.
  - Remove method `BluetoothService.findIncludedService`.
  - Remove method `BluetoothAdapter.findService`.
  - Remove method `BluetoothDevice.findService`.
  - Remove method `BluetoothDevice.getServices`.
  - Remove method `BluetoothService.addCharacteristic`.
  - Remove method `BluetoothService.findCharacteristic`.
  - Remove method `BluetoothService.getCharacteristics`.
  - Remove method `BluetoothCharacteristic.addDescriptor`.
  - Remove method `BluetoothCharacteristic.findDescriptor`.
  - Remove method `BluetoothCharacteristic.getDescriptors`.

## 1.0.2 - 2019-12-12

### Changed
  - Use MMM in module definition.

## 1.0.1 - 2019-06-19

### Fixed
  - Fix module compatibility with MicroEJ 4.

## 1.0.0 - 2019-03-12

### Added
  - Scan nearby devices.
  - Advertise to nearby devices.
  - Connect to and disconnect from a device.
  - Pair with a device.
  - Reply to a pairing request from a device.
  - Provide GATT services.
  - Discover the GATT services provided by a device.
  - Read or write a characteristic or descriptor of a device.
  - Reply to a read or write request from a device.
  - Send characteristic notifications and indications to a device.

---
_Copyright 2018-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
