# Overview

An addon-processor for converting a `tzdb.dat` file (included in JDKs) into a ResourceBuffer file.

The `tzdb.dat` file must be referenced by a `.tzdb.list` file in the project main folders.

## ResourceBuffer file format

- Header: 8 bytes
	- 'MEJ_TZD': 7 bytes
	- format version : 1 byte
- tzdb version id: String (e.g., "2019c")
- zones count: 2 bytes
- zones ids: array of [zones count] strings (sorted, natural ordering)
- zone rules: array of unique ZoneRules objects (length <= [zones count])
- zone ids offsets: array of [zones count] offsets = positions of the zone ids in the resource buffer (positions on 4 bytes)
- rules offsets: array of [zones count] offsets = positions of the rule objects in the resource buffer (positions on 4 bytes)

The arrays of offsets are used for direct access to the rules and zone ids objects in the resource buffer, given the index of a zone id.

# Usage

Add the following line to your `module.ivy`:
	
    <dependency org="com.microej.tool.addon.runtime" name="tzdb-processor" rev="1.0.0"/>
	
# Requirements

This library requires the following Foundation Libraries:

    ADDON-PROCESSOR-API-1.1

# Dependencies

_All dependencies are retrieved transitively by Ivy resolver_.

# Source

Types `ZoneRules`, `ZoneOffsetTransition`, `ZoneOffsetTransitionRule` and `Ser` are derived from OpenJDK 8 u362-ga.

# Source

None.

# Restrictions

None.


---    
_Markdown_  
_Copyright 2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp._
_DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER._
_ _
_This code is free software; you can redistribute it and/or modify it_
_under the terms of the GNU General Public License version 2 only, as_
_published by the Free Software Foundation.  Oracle designates this_
_particular file as subject to the "Classpath" exception as provided_
_by Oracle in the LICENSE file that accompanied this code._
_ _
_This code is distributed in the hope that it will be useful, but WITHOUT_
_ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or_
_FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License_
_version 2 for more details (a copy is included in the LICENSE file that_
_accompanied this code)._
_ _
_You should have received a copy of the GNU General Public License version_
_2 along with this work; if not, write to the Free Software Foundation,_
_Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA._
_ _
_Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA_
_or visit www.oracle.com if you need additional information or have any_
_questions. _