# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [3.2.0] - 2025-03-28

### Added

  - Add a basic support for plural rules in Android string resources.

## [3.1.0] - 2024-03-25

### Added

  - Add a support to convert the translations to store in the binary files.

### Changed

  - Use version 3.1.0 of the Addon Processor (binary-nls-processor).

## [3.0.0] - 2023-07-04

### Added

  - Add implementation for NLS methods for handling messages with plural forms.
  - Add NLSPlural Java interface to use generated "*Plural" Java classes.
  - Add tests for common plural forms use cases.

### Changed

  - Use version 3.0.0 of binary-nls-processor.
  - Use version 4.0.0 of NLS.
  - Update buildtype to version 6.2.+.

## [2.6.0] - 2023-05-19

### Added

  - Add internal support for processing plural form messages in PO files.

## [2.5.0] - 2022-10-11

### Added

  - Add test for the fallback locale feature newly added to the Addon Processor.
  - Improve BinaryNLS class documentation.

### Changed

  - Use version 2.5.0 of the Addon Processor (binary-nls-processor).
  
### Fixed

  - Fix UTF-8 encoding bug in XML parser.

## [2.4.2] - 2022-05-23

### Changed

  - Use version 2.4.2 of the Addon Processor (binary-nls-processor).

## [2.4.1] - 2022-05-16

### Changed

  - Use version 2.4.1 of the Addon Processor (binary-nls-processor).
  - Update license.

## [2.4.0] - 2022-05-16

### Added

  - Add support for Android String resources. Use version 2.4.0 of the Addon Processor (binary-nls-processor).

### Changed

  - Change module name (formerly nls-po).
  - Change name of default locale and default implementation properties.

### Fixed

  - Fix the case of the name of the generated message fields when the key contains an `_`.

## [2.3.0] - 2021-09-15

### Changed

  - Use version 2.3.0 of the Addon Processor (NLS-PO-Processor).

## [2.2.0] - 2019-12-17

### Changed

  - Use MMM.
  
## [2.1.5] - 2018-12-17

### Changed

  - Use null analysis annotations.

## [2.1.4] - 2018-11-06

### Fixed

  - Escape characters in the comments generated for messages.

## [2.1.3] - 2018-10-31

### Fixed

  - Fix ResourceBuffer synchronization (potential IndexOutOfBoundsException when changing the current locale and retrieving a message at the same time).

## [2.1.2] - 2018-10-10

### Fixed

  - Use message library instead of error message. 

## [2.1.1] - 2018-07-04

### Fixed

  - Setting the default locale does not work.

## [2.1.0] - 2018-03-28

### Changed

  - Manage different kinds of errors.
  - Allow to use a fully qualified class name in a string (instead of retrieving it from the required type).
  - Manage a fallback implementation if binary is missing or corrupted.

## [2.0.1] - 2017-10-27

### Fixed

  - Synchronization error when accessing on messages and locales.

## [2.0.0] - 2017-07-20

### Changed

  - Change binary format, remove immutables, integrate addon processor etc.

## [1.0.1] - 2016-12-12

### Fixed

  - Fix native version.

## [1.0.0] - 2016-09-20

### Changed

  - Initial revision (extracted from GIML runtime).

---  
_Copyright 2016-2025 MicroEJ Corp. All rights reserved._\
_This library is provided in source code for use, modification and test, subject to license terms._\
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._
